 ; Ŀ
 ;   Obl - kill blocks by multiple example.                                
 ;   Copyright 2005, 2006 by Rocket Software Ltd.                          
 ;   Also contains Obx - explode rather than kill the blocks.              
 ;   There is a fine line between diligent and neurotic.                   
 ; 

 ; Ŀ
 ;   Obx.                                                                  
 ; 
 (DEFUN C:OBX (/ num ss enam blist blnam len num numss)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Get a selection set of blocks to use as examples.                     
 ; 
  (prompt "Select stuff containing examples of blocks to explode: ")
  (setq num 0)
  (if (setq ss (ssget (list (cons 0 "insert"))))
      (while (setq enam (ssname ss num))
             (setq num (1+ num))
             (setq blnam (cdr (assoc 2 (entget enam))))
             (if (= (substr blnam 1 1) "*")             ; escape * so that
                 (setq blnam (strcat "`" blnam)))       ; can find hatches
             (if (not (member blnam blist))
                 (setq blist (cons blnam blist)))))
 ; Ŀ
 ;   Now explode any blocks named in the list.                             
 ; 
  (setq num 0)
  (while (setq blnam (nth num blist))
         (setq num (1+ num))
         (if (setq ss (ssget "X" (list (cons 2 blnam))))
             (progn
                  (setq blnam (strcat (strcase (substr blnam 1 1))
                              (strcase (substr blnam 2) t)))
                  (setq len (sslength ss))
                  (setq numss 0)
                  (while (setq enam (ssname ss numss))
                         (command ".explode" enam)
                         (setq numss (1+ numss)))
                  (if (= (substr blnam 1 1) "`")       ; remove hatch * escape
                      (setq blnam (substr blnam 2)))   ; char ` if present
                   (prompt (strcat "\n" (itoa len) " " blnam
                                   " insert" (if (/= len 1) "s" "")
                                   " exploded.")))
              (prompt (strcat "\nNo " blnam " inserts found."
                              "  This is not possible."))))
  (command "undo" "end")
 (princ))

 ; Ŀ
 ;   Obl.                                                                  
 ; 
 (DEFUN C:OBL (/ num ss enam blist blnam len)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Get a selection set of blocks to use as examples.                     
 ; 
  (prompt "Select stuff containing examples of blocks to kill: ")
  (setq num 0)
  (if (setq ss (ssget (list (cons 0 "insert"))))
      (while (setq enam (ssname ss num))
             (setq num (1+ num))
             (setq blnam (cdr (assoc 2 (entget enam))))
             (if (= (substr blnam 1 1) "*")             ; escape * so that
                 (setq blnam (strcat "`" blnam)))       ; can find hatches
             (if (not (member blnam blist))
                 (setq blist (cons blnam blist)))))
 ; Ŀ
 ;   Now kill any blocks named in the list.                                
 ; 
  (setq num 0)
  (while (setq blnam (nth num blist))
         (setq num (1+ num))
         (if (setq ss (ssget "X" (list (cons 2 blnam))))
             (progn
                  (setq blnam (strcat (strcase (substr blnam 1 1))
                              (strcase (substr blnam 2) t)))
                  (setq len (sslength ss))
                  (command "erase" ss "")
                  (if (= (substr blnam 1 1) "`")       ; remove hatch * escape
                      (setq blnam (substr blnam 2)))   ; char ` if present
                   (prompt (strcat "\n" (itoa len) " " blnam
                                   " insert" (if (/= len 1) "s" "")
                                   " erased.")))
              (prompt (strcat "\nNo " blnam " inserts found."
                              "  This is not possible."))))
  (command "undo" "end")
 (princ))